/*
 * Decompiled with CFR 0.152.
 */
package me.micartey.jcloak.dependencies.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Type {
    public static final int VOID = 0;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int FLOAT = 6;
    public static final int LONG = 7;
    public static final int DOUBLE = 8;
    public static final int ARRAY = 9;
    public static final int OBJECT = 10;
    public static final int METHOD = 11;
    private static final int INTERNAL = 12;
    private static final String PRIMITIVE_DESCRIPTORS = "VZCBSIFJD";
    public static final Type VOID_TYPE = new Type(0, "VZCBSIFJD", 0, 1);
    public static final Type BOOLEAN_TYPE = new Type(1, "VZCBSIFJD", 1, 2);
    public static final Type CHAR_TYPE = new Type(2, "VZCBSIFJD", 2, 3);
    public static final Type BYTE_TYPE = new Type(3, "VZCBSIFJD", 3, 4);
    public static final Type SHORT_TYPE = new Type(4, "VZCBSIFJD", 4, 5);
    public static final Type INT_TYPE = new Type(5, "VZCBSIFJD", 5, 6);
    public static final Type FLOAT_TYPE = new Type(6, "VZCBSIFJD", 6, 7);
    public static final Type LONG_TYPE = new Type(7, "VZCBSIFJD", 7, 8);
    public static final Type DOUBLE_TYPE = new Type(8, "VZCBSIFJD", 8, 9);
    private final int sort;
    private final String valueBuffer;
    private final int valueBegin;
    private final int valueEnd;

    private Type(int n, String string, int n2, int n3) {
        this.sort = n;
        this.valueBuffer = string;
        this.valueBegin = n2;
        this.valueEnd = n3;
    }

    public static Type getType(String string) {
        return Type.getTypeInternal(string, 0, string.length());
    }

    public static Type getType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_TYPE;
            }
            if (clazz == Void.TYPE) {
                return VOID_TYPE;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_TYPE;
            }
            if (clazz == Byte.TYPE) {
                return BYTE_TYPE;
            }
            if (clazz == Character.TYPE) {
                return CHAR_TYPE;
            }
            if (clazz == Short.TYPE) {
                return SHORT_TYPE;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE_TYPE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT_TYPE;
            }
            if (clazz == Long.TYPE) {
                return LONG_TYPE;
            }
            throw new AssertionError();
        }
        return Type.getType(Type.getDescriptor(clazz));
    }

    public static Type getType(Constructor<?> constructor) {
        return Type.getType(Type.getConstructorDescriptor(constructor));
    }

    public static Type getType(Method method) {
        return Type.getType(Type.getMethodDescriptor(method));
    }

    public Type getElementType() {
        int n = this.getDimensions();
        return Type.getTypeInternal(this.valueBuffer, this.valueBegin + n, this.valueEnd);
    }

    public static Type getObjectType(String string) {
        return new Type(string.charAt(0) == '[' ? 9 : 12, string, 0, string.length());
    }

    public static Type getMethodType(String string) {
        return new Type(11, string, 0, string.length());
    }

    public static Type getMethodType(Type type, Type ... typeArray) {
        return Type.getType(Type.getMethodDescriptor(type, typeArray));
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.getDescriptor());
    }

    public static Type[] getArgumentTypes(String string) {
        int n = 0;
        int n2 = 1;
        while (string.charAt(n2) != ')') {
            while (string.charAt(n2) == '[') {
                ++n2;
            }
            if (string.charAt(n2++) == 'L') {
                int n3 = string.indexOf(59, n2);
                n2 = Math.max(n2, n3 + 1);
            }
            ++n;
        }
        Type[] typeArray = new Type[n];
        n2 = 1;
        int n4 = 0;
        while (string.charAt(n2) != ')') {
            int n5 = n2;
            while (string.charAt(n2) == '[') {
                ++n2;
            }
            if (string.charAt(n2++) == 'L') {
                int n6 = string.indexOf(59, n2);
                n2 = Math.max(n2, n6 + 1);
            }
            typeArray[n4++] = Type.getTypeInternal(string, n5, n2);
        }
        return typeArray;
    }

    public static Type[] getArgumentTypes(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        Type[] typeArray = new Type[classArray.length];
        for (int i = classArray.length - 1; i >= 0; --i) {
            typeArray[i] = Type.getType(classArray[i]);
        }
        return typeArray;
    }

    public Type getReturnType() {
        return Type.getReturnType(this.getDescriptor());
    }

    public static Type getReturnType(String string) {
        return Type.getTypeInternal(string, Type.getReturnTypeOffset(string), string.length());
    }

    public static Type getReturnType(Method method) {
        return Type.getType(method.getReturnType());
    }

    static int getReturnTypeOffset(String string) {
        int n = 1;
        while (string.charAt(n) != ')') {
            while (string.charAt(n) == '[') {
                ++n;
            }
            if (string.charAt(n++) != 'L') continue;
            int n2 = string.indexOf(59, n);
            n = Math.max(n, n2 + 1);
        }
        return n + 1;
    }

    private static Type getTypeInternal(String string, int n, int n2) {
        switch (string.charAt(n)) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                return new Type(9, string, n, n2);
            }
            case 'L': {
                return new Type(10, string, n + 1, n2 - 1);
            }
            case '(': {
                return new Type(11, string, n, n2);
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + string);
    }

    public String getClassName() {
        switch (this.sort) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                StringBuilder stringBuilder = new StringBuilder(this.getElementType().getClassName());
                for (int i = this.getDimensions(); i > 0; --i) {
                    stringBuilder.append("[]");
                }
                return stringBuilder.toString();
            }
            case 10: 
            case 12: {
                return this.valueBuffer.substring(this.valueBegin, this.valueEnd).replace('/', '.');
            }
        }
        throw new AssertionError();
    }

    public String getInternalName() {
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    public static String getInternalName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public String getDescriptor() {
        if (this.sort == 10) {
            return this.valueBuffer.substring(this.valueBegin - 1, this.valueEnd + 1);
        }
        if (this.sort == 12) {
            return 'L' + this.valueBuffer.substring(this.valueBegin, this.valueEnd) + ';';
        }
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    public static String getDescriptor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        Type.appendDescriptor(clazz, stringBuilder);
        return stringBuilder.toString();
    }

    public static String getConstructorDescriptor(Constructor<?> constructor) {
        Class<?>[] classArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> clazz : classArray = constructor.getParameterTypes()) {
            Type.appendDescriptor(clazz, stringBuilder);
        }
        return stringBuilder.append(")V").toString();
    }

    public static String getMethodDescriptor(Type type, Type ... typeArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Type type2 : typeArray) {
            type2.appendDescriptor(stringBuilder);
        }
        stringBuilder.append(')');
        type.appendDescriptor(stringBuilder);
        return stringBuilder.toString();
    }

    public static String getMethodDescriptor(Method method) {
        Class<?>[] classArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> clazz : classArray = method.getParameterTypes()) {
            Type.appendDescriptor(clazz, stringBuilder);
        }
        stringBuilder.append(')');
        Type.appendDescriptor(method.getReturnType(), stringBuilder);
        return stringBuilder.toString();
    }

    private void appendDescriptor(StringBuilder stringBuilder) {
        if (this.sort == 10) {
            stringBuilder.append(this.valueBuffer, this.valueBegin - 1, this.valueEnd + 1);
        } else if (this.sort == 12) {
            stringBuilder.append('L').append(this.valueBuffer, this.valueBegin, this.valueEnd).append(';');
        } else {
            stringBuilder.append(this.valueBuffer, this.valueBegin, this.valueEnd);
        }
    }

    private static void appendDescriptor(Class<?> clazz, StringBuilder stringBuilder) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            stringBuilder.append('[');
            clazz2 = clazz2.getComponentType();
        }
        if (clazz2.isPrimitive()) {
            int n;
            if (clazz2 == Integer.TYPE) {
                n = 73;
            } else if (clazz2 == Void.TYPE) {
                n = 86;
            } else if (clazz2 == Boolean.TYPE) {
                n = 90;
            } else if (clazz2 == Byte.TYPE) {
                n = 66;
            } else if (clazz2 == Character.TYPE) {
                n = 67;
            } else if (clazz2 == Short.TYPE) {
                n = 83;
            } else if (clazz2 == Double.TYPE) {
                n = 68;
            } else if (clazz2 == Float.TYPE) {
                n = 70;
            } else if (clazz2 == Long.TYPE) {
                n = 74;
            } else {
                throw new AssertionError();
            }
            stringBuilder.append((char)n);
        } else {
            stringBuilder.append('L').append(Type.getInternalName(clazz2)).append(';');
        }
    }

    public int getSort() {
        return this.sort == 12 ? 10 : this.sort;
    }

    public int getDimensions() {
        int n = 1;
        while (this.valueBuffer.charAt(this.valueBegin + n) == '[') {
            ++n;
        }
        return n;
    }

    public int getSize() {
        switch (this.sort) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                return 1;
            }
            case 7: 
            case 8: {
                return 2;
            }
        }
        throw new AssertionError();
    }

    public int getArgumentsAndReturnSizes() {
        return Type.getArgumentsAndReturnSizes(this.getDescriptor());
    }

    public static int getArgumentsAndReturnSizes(String string) {
        int n;
        int n2 = 1;
        int n3 = 1;
        char c = string.charAt(n3);
        while (c != ')') {
            if (c == 'J' || c == 'D') {
                ++n3;
                n2 += 2;
            } else {
                while (string.charAt(n3) == '[') {
                    ++n3;
                }
                if (string.charAt(n3++) == 'L') {
                    n = string.indexOf(59, n3);
                    n3 = Math.max(n3, n + 1);
                }
                ++n2;
            }
            c = string.charAt(n3);
        }
        c = string.charAt(n3 + 1);
        if (c == 'V') {
            return n2 << 2;
        }
        n = c == 'J' || c == 'D' ? 2 : 1;
        return n2 << 2 | n;
    }

    public int getOpcode(int n) {
        if (n == 46 || n == 79) {
            switch (this.sort) {
                case 1: 
                case 3: {
                    return n + 5;
                }
                case 2: {
                    return n + 6;
                }
                case 4: {
                    return n + 7;
                }
                case 5: {
                    return n;
                }
                case 6: {
                    return n + 2;
                }
                case 7: {
                    return n + 1;
                }
                case 8: {
                    return n + 3;
                }
                case 9: 
                case 10: 
                case 12: {
                    return n + 4;
                }
                case 0: 
                case 11: {
                    throw new UnsupportedOperationException();
                }
            }
            throw new AssertionError();
        }
        switch (this.sort) {
            case 0: {
                if (n != 172) {
                    throw new UnsupportedOperationException();
                }
                return 177;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return n;
            }
            case 6: {
                return n + 2;
            }
            case 7: {
                return n + 1;
            }
            case 8: {
                return n + 3;
            }
            case 9: 
            case 10: 
            case 12: {
                if (n != 21 && n != 54 && n != 172) {
                    throw new UnsupportedOperationException();
                }
                return n + 4;
            }
            case 11: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Type)) {
            return false;
        }
        Type type = (Type)object;
        if ((this.sort == 12 ? 10 : this.sort) != (type.sort == 12 ? 10 : type.sort)) {
            return false;
        }
        int n = this.valueEnd;
        int n2 = this.valueBegin;
        int n3 = type.valueEnd;
        int n4 = type.valueBegin;
        if (n - n2 != n3 - n4) {
            return false;
        }
        int n5 = n2;
        int n6 = n4;
        while (n5 < n) {
            if (this.valueBuffer.charAt(n5) != type.valueBuffer.charAt(n6)) {
                return false;
            }
            ++n5;
            ++n6;
        }
        return true;
    }

    public int hashCode() {
        int n = 13 * (this.sort == 12 ? 10 : this.sort);
        if (this.sort >= 9) {
            int n2 = this.valueEnd;
            for (int i = this.valueBegin; i < n2; ++i) {
                n = 17 * (n + this.valueBuffer.charAt(i));
            }
        }
        return n;
    }

    public String toString() {
        return this.getDescriptor();
    }
}

