/*
 * Decompiled with CFR 0.152.
 */
package me.micartey.jcloak.dependencies.asm;

import me.micartey.jcloak.dependencies.asm.AnnotationVisitor;
import me.micartey.jcloak.dependencies.asm.AnnotationWriter;
import me.micartey.jcloak.dependencies.asm.Attribute;
import me.micartey.jcloak.dependencies.asm.Attribute$Set;
import me.micartey.jcloak.dependencies.asm.ByteVector;
import me.micartey.jcloak.dependencies.asm.RecordComponentVisitor;
import me.micartey.jcloak.dependencies.asm.SymbolTable;
import me.micartey.jcloak.dependencies.asm.TypePath;

final class RecordComponentWriter
extends RecordComponentVisitor {
    private final SymbolTable symbolTable;
    private final int nameIndex;
    private final int descriptorIndex;
    private int signatureIndex;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private Attribute firstAttribute;

    RecordComponentWriter(SymbolTable symbolTable, String string, String string2, String string3) {
        super(589824);
        this.symbolTable = symbolTable;
        this.nameIndex = symbolTable.addConstantUtf8(string);
        this.descriptorIndex = symbolTable.addConstantUtf8(string2);
        if (string3 != null) {
            this.signatureIndex = symbolTable.addConstantUtf8(string3);
        }
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (bl) {
            this.lastRuntimeVisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        if (bl) {
            this.lastRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n, typePath, string, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n, typePath, string, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    public void visitAttribute(Attribute attribute) {
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = attribute;
    }

    public void visitEnd() {
    }

    int computeRecordComponentInfoSize() {
        int n = 6;
        n += Attribute.computeAttributesSize(this.symbolTable, 0, this.signatureIndex);
        n += AnnotationWriter.computeAnnotationsSize(this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation);
        if (this.firstAttribute != null) {
            n += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        return n;
    }

    void putRecordComponentInfo(ByteVector byteVector) {
        byteVector.putShort(this.nameIndex).putShort(this.descriptorIndex);
        int n = 0;
        if (this.signatureIndex != 0) {
            ++n;
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++n;
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++n;
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++n;
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++n;
        }
        if (this.firstAttribute != null) {
            n += this.firstAttribute.getAttributeCount();
        }
        byteVector.putShort(n);
        Attribute.putAttributes(this.symbolTable, 0, this.signatureIndex, byteVector);
        AnnotationWriter.putAnnotations(this.symbolTable, this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation, byteVector);
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, byteVector);
        }
    }

    final void collectAttributePrototypes(Attribute$Set attribute$Set) {
        attribute$Set.addAttributes(this.firstAttribute);
    }
}

