/*
 * Decompiled with CFR 0.152.
 */
package me.micartey.jcloak.dependencies.asm;

import me.micartey.jcloak.dependencies.asm.AnnotationVisitor;
import me.micartey.jcloak.dependencies.asm.AnnotationWriter;
import me.micartey.jcloak.dependencies.asm.Attribute;
import me.micartey.jcloak.dependencies.asm.Attribute$Set;
import me.micartey.jcloak.dependencies.asm.ByteVector;
import me.micartey.jcloak.dependencies.asm.FieldVisitor;
import me.micartey.jcloak.dependencies.asm.SymbolTable;
import me.micartey.jcloak.dependencies.asm.TypePath;

final class FieldWriter
extends FieldVisitor {
    private final SymbolTable symbolTable;
    private final int accessFlags;
    private final int nameIndex;
    private final int descriptorIndex;
    private int signatureIndex;
    private int constantValueIndex;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private Attribute firstAttribute;

    FieldWriter(SymbolTable symbolTable, int n, String string, String string2, String string3, Object object) {
        super(589824);
        this.symbolTable = symbolTable;
        this.accessFlags = n;
        this.nameIndex = symbolTable.addConstantUtf8(string);
        this.descriptorIndex = symbolTable.addConstantUtf8(string2);
        if (string3 != null) {
            this.signatureIndex = symbolTable.addConstantUtf8(string3);
        }
        if (object != null) {
            this.constantValueIndex = symbolTable.addConstant((Object)object).index;
        }
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (bl) {
            this.lastRuntimeVisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        if (bl) {
            this.lastRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n, typePath, string, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n, typePath, string, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    public void visitAttribute(Attribute attribute) {
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = attribute;
    }

    public void visitEnd() {
    }

    int computeFieldInfoSize() {
        int n = 8;
        if (this.constantValueIndex != 0) {
            this.symbolTable.addConstantUtf8("ConstantValue");
            n += 8;
        }
        n += Attribute.computeAttributesSize(this.symbolTable, this.accessFlags, this.signatureIndex);
        n += AnnotationWriter.computeAnnotationsSize(this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation);
        if (this.firstAttribute != null) {
            n += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        return n;
    }

    void putFieldInfo(ByteVector byteVector) {
        boolean bl = this.symbolTable.getMajorVersion() < 49;
        int n = bl ? 4096 : 0;
        byteVector.putShort(this.accessFlags & ~n).putShort(this.nameIndex).putShort(this.descriptorIndex);
        int n2 = 0;
        if (this.constantValueIndex != 0) {
            ++n2;
        }
        if ((this.accessFlags & 0x1000) != 0 && bl) {
            ++n2;
        }
        if (this.signatureIndex != 0) {
            ++n2;
        }
        if ((this.accessFlags & 0x20000) != 0) {
            ++n2;
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++n2;
        }
        if (this.firstAttribute != null) {
            n2 += this.firstAttribute.getAttributeCount();
        }
        byteVector.putShort(n2);
        if (this.constantValueIndex != 0) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("ConstantValue")).putInt(2).putShort(this.constantValueIndex);
        }
        Attribute.putAttributes(this.symbolTable, this.accessFlags, this.signatureIndex, byteVector);
        AnnotationWriter.putAnnotations(this.symbolTable, this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation, byteVector);
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, byteVector);
        }
    }

    final void collectAttributePrototypes(Attribute$Set attribute$Set) {
        attribute$Set.addAttributes(this.firstAttribute);
    }
}

