/*
 * Decompiled with CFR 0.152.
 */
package me.micartey.jcloak.dependencies.webhookly;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JSONObject {
    private final HashMap<String, Object> map = new HashMap();

    void put(String string, Object object) {
        if (object == null) {
            return;
        }
        this.map.put(string, object);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set<Map.Entry<String, Object>> set = this.map.entrySet();
        stringBuilder.append("{");
        int n = 0;
        for (Map.Entry<String, Object> entry : set) {
            Object object = entry.getValue();
            stringBuilder.append(this.escape(entry.getKey())).append(":");
            if (object instanceof String) {
                stringBuilder.append(this.escape(String.valueOf(object)));
            } else if (object instanceof Integer) {
                stringBuilder.append(Integer.valueOf(String.valueOf(object)));
            } else if (object instanceof Boolean) {
                stringBuilder.append(object);
            } else if (object instanceof JSONObject) {
                stringBuilder.append(object);
            } else if (object.getClass().isArray()) {
                stringBuilder.append("[");
                int n2 = Array.getLength(object);
                for (int i = 0; i < n2; ++i) {
                    stringBuilder.append(Array.get(object, i).toString()).append(i != n2 - 1 ? "," : "");
                }
                stringBuilder.append("]");
            }
            stringBuilder.append(++n == set.size() ? "}" : ",");
        }
        return stringBuilder.toString();
    }

    private String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder("\"");
        for (char c : string.toCharArray()) {
            if (c == '\\' || c == '\"' || c == '/') {
                stringBuilder.append("\\").append(c);
                continue;
            }
            if (c == '\b') {
                stringBuilder.append("\\b");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\f') {
                stringBuilder.append("\\f");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                stringBuilder.append(String.format("\\u%04x", c));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.append('\"').toString();
    }
}

