/*
 * Decompiled with CFR 0.152.
 */
package me.micartey.jcloak.dependencies.webhookly;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import me.micartey.jcloak.dependencies.webhookly.JSONObject;
import me.micartey.jcloak.dependencies.webhookly.embeds.EmbedObject;

public class DiscordWebhook {
    private final List<EmbedObject> embeds = new ArrayList<EmbedObject>();
    private final String url;
    private String content;
    private String username;
    private String avatarUrl;
    private boolean tts;

    public void execute() throws IOException {
        Serializable serializable;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("content", this.content);
        jSONObject.put("username", this.username);
        jSONObject.put("avatar_url", this.avatarUrl);
        jSONObject.put("tts", this.tts);
        if (!this.embeds.isEmpty()) {
            serializable = new ArrayList();
            for (EmbedObject object2 : this.embeds) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("title", object2.getTitle());
                jSONObject2.put("description", object2.getDescription());
                jSONObject2.put("url", object2.getUrl());
                Optional.ofNullable(object2.getColor()).ifPresent(color -> {
                    int n = color.getRed();
                    n = (n << 8) + color.getGreen();
                    n = (n << 8) + color.getBlue();
                    jSONObject2.put("color", n);
                });
                Optional.ofNullable(object2.getTimestamp()).ifPresent(offsetDateTime -> {
                    String string = offsetDateTime.toString();
                    jSONObject2.put("timestamp", string);
                });
                Optional.ofNullable(object2.getFooter()).ifPresent(footer -> {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("text", footer.getText());
                    jSONObject2.put("icon_url", footer.getIconUrl());
                    jSONObject2.put("footer", jSONObject2);
                });
                Optional.ofNullable(object2.getImage()).ifPresent(image -> {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("url", image.getUrl());
                    jSONObject2.put("image", jSONObject2);
                });
                Optional.ofNullable(object2.getThumbnail()).ifPresent(thumbnail -> {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("url", thumbnail.getUrl());
                    jSONObject2.put("thumbnail", jSONObject2);
                });
                Optional.ofNullable(object2.getAuthor()).ifPresent(author -> {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("name", author.getName());
                    jSONObject2.put("url", author.getUrl());
                    jSONObject2.put("icon_url", author.getIconUrl());
                    jSONObject2.put("author", jSONObject2);
                });
                ArrayList arrayList = new ArrayList();
                Optional.ofNullable(object2.getFields()).ifPresent(list2 -> list2.forEach(field -> {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("name", field.getName());
                    jSONObject.put("value", field.getValue());
                    jSONObject.put("inline", field.isInline());
                    arrayList.add(jSONObject);
                }));
                jSONObject2.put("fields", arrayList.toArray());
                serializable.add(jSONObject2);
            }
            jSONObject.put("embeds", serializable.toArray());
        }
        serializable = new URL(this.url);
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)((URL)serializable).openConnection();
        httpsURLConnection.addRequestProperty("Content-Type", "application/json");
        httpsURLConnection.addRequestProperty("User-Agent", "webhookly");
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setRequestMethod("POST");
        OutputStream outputStream = httpsURLConnection.getOutputStream();
        outputStream.write(jSONObject.toString().getBytes());
        outputStream.flush();
        outputStream.close();
        httpsURLConnection.getInputStream().close();
        httpsURLConnection.disconnect();
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setAvatarUrl(String string) {
        this.avatarUrl = string;
    }

    public void setTts(boolean bl) {
        this.tts = bl;
    }

    public DiscordWebhook(String string) {
        this.url = string;
    }

    public List<EmbedObject> getEmbeds() {
        return this.embeds;
    }
}

