/*
 * Decompiled with CFR 0.152.
 */
package me.micartey.jcloak.dependencies.deencapsulation;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import sun.reflect.ReflectionFactory;

public final class Deencapsulation {
    private static MethodHandles.Lookup lookup(Class<?> clazz) {
        try {
            Constructor<?> constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(MethodHandles.Lookup.class, MethodHandles.Lookup.class.getDeclaredConstructor(Class.class));
            return (MethodHandles.Lookup)constructor.newInstance(clazz);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IllegalStateException("That should have not happened", reflectiveOperationException);
        }
    }

    private static Set<Module> getModules(Class<?> clazz) {
        HashSet<Module> hashSet = new HashSet<Module>();
        Module module = clazz.getModule();
        ModuleLayer moduleLayer = module.getLayer();
        if (moduleLayer != null) {
            hashSet.addAll(moduleLayer.modules());
        }
        hashSet.addAll(ModuleLayer.boot().modules());
        for (ClassLoader classLoader = clazz.getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            hashSet.add(classLoader.getUnnamedModule());
        }
        return hashSet;
    }

    public static void deencapsulate(Class<?> clazz) {
        Set<Module> set = Deencapsulation.getModules(clazz);
        try {
            MethodHandle methodHandle = Deencapsulation.lookup(Module.class).findVirtual(Module.class, "implAddOpens", MethodType.methodType(Void.TYPE, String.class));
            for (Module module : set) {
                for (String string : module.getPackages()) {
                    methodHandle.invokeExact(module, string);
                }
            }
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Could not export packages", throwable);
        }
    }

    public static void allowNative(Class<?> clazz) {
        Set<Module> set = Deencapsulation.getModules(clazz);
        try {
            MethodHandle methodHandle = Deencapsulation.lookup(Module.class).findVirtual(Module.class, "implAddEnableNativeAccess", MethodType.methodType(Module.class));
            for (Module module : set) {
                methodHandle.invokeExact(module);
            }
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Could not export packages", throwable);
        }
    }
}

