/*
 * Decompiled with CFR 0.152.
 */
package me.micartey.jcloak.dependencies.asm;

import me.micartey.jcloak.dependencies.asm.ByteVector;
import me.micartey.jcloak.dependencies.asm.ClassReader;
import me.micartey.jcloak.dependencies.asm.ClassWriter;
import me.micartey.jcloak.dependencies.asm.ConstantDynamic;
import me.micartey.jcloak.dependencies.asm.Handle;
import me.micartey.jcloak.dependencies.asm.Symbol;
import me.micartey.jcloak.dependencies.asm.SymbolTable$Entry;
import me.micartey.jcloak.dependencies.asm.Type;

final class SymbolTable {
    final ClassWriter classWriter;
    private final ClassReader sourceClassReader;
    private int majorVersion;
    private String className;
    private int entryCount;
    private SymbolTable$Entry[] entries;
    private int constantPoolCount;
    private ByteVector constantPool;
    private int bootstrapMethodCount;
    private ByteVector bootstrapMethods;
    private int typeCount;
    private SymbolTable$Entry[] typeTable;

    SymbolTable(ClassWriter classWriter) {
        this.classWriter = classWriter;
        this.sourceClassReader = null;
        this.entries = new SymbolTable$Entry[256];
        this.constantPoolCount = 1;
        this.constantPool = new ByteVector();
    }

    SymbolTable(ClassWriter classWriter, ClassReader classReader) {
        byte by;
        this.classWriter = classWriter;
        this.sourceClassReader = classReader;
        byte[] byArray = classReader.classFileBuffer;
        int n = classReader.getItem(1) - 1;
        int n2 = classReader.header - n;
        this.constantPoolCount = classReader.getItemCount();
        this.constantPool = new ByteVector(n2);
        this.constantPool.putByteArray(byArray, n, n2);
        this.entries = new SymbolTable$Entry[this.constantPoolCount * 2];
        char[] cArray = new char[classReader.getMaxStringLength()];
        boolean bl = false;
        block10: for (int i = 1; i < this.constantPoolCount; i += by == 5 || by == 6 ? 2 : 1) {
            int n3 = classReader.getItem(i);
            by = byArray[n3 - 1];
            switch (by) {
                case 9: 
                case 10: 
                case 11: {
                    int n4 = classReader.getItem(classReader.readUnsignedShort(n3 + 2));
                    this.addConstantMemberReference(i, by, classReader.readClass(n3, cArray), classReader.readUTF8(n4, cArray), classReader.readUTF8(n4 + 2, cArray));
                    continue block10;
                }
                case 3: 
                case 4: {
                    this.addConstantIntegerOrFloat(i, by, classReader.readInt(n3));
                    continue block10;
                }
                case 12: {
                    this.addConstantNameAndType(i, classReader.readUTF8(n3, cArray), classReader.readUTF8(n3 + 2, cArray));
                    continue block10;
                }
                case 5: 
                case 6: {
                    this.addConstantLongOrDouble(i, by, classReader.readLong(n3));
                    continue block10;
                }
                case 1: {
                    this.addConstantUtf8(i, classReader.readUtf(i, cArray));
                    continue block10;
                }
                case 15: {
                    int n5 = classReader.getItem(classReader.readUnsignedShort(n3 + 1));
                    int n4 = classReader.getItem(classReader.readUnsignedShort(n5 + 2));
                    this.addConstantMethodHandle(i, classReader.readByte(n3), classReader.readClass(n5, cArray), classReader.readUTF8(n4, cArray), classReader.readUTF8(n4 + 2, cArray));
                    continue block10;
                }
                case 17: 
                case 18: {
                    bl = true;
                    int n4 = classReader.getItem(classReader.readUnsignedShort(n3 + 2));
                    this.addConstantDynamicOrInvokeDynamicReference(by, i, classReader.readUTF8(n4, cArray), classReader.readUTF8(n4 + 2, cArray), classReader.readUnsignedShort(n3));
                    continue block10;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    this.addConstantUtf8Reference(i, by, classReader.readUTF8(n3, cArray));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (bl) {
            this.copyBootstrapMethods(classReader, cArray);
        }
    }

    private void copyBootstrapMethods(ClassReader classReader, char[] cArray) {
        int n;
        byte[] byArray = classReader.classFileBuffer;
        int n2 = classReader.getFirstAttributeOffset();
        for (n = classReader.readUnsignedShort(n2 - 2); n > 0; --n) {
            String string = classReader.readUTF8(n2, cArray);
            if ("BootstrapMethods".equals(string)) {
                this.bootstrapMethodCount = classReader.readUnsignedShort(n2 + 6);
                break;
            }
            n2 += 6 + classReader.readInt(n2 + 2);
        }
        if (this.bootstrapMethodCount > 0) {
            n = n2 + 8;
            int n3 = classReader.readInt(n2 + 2) - 2;
            this.bootstrapMethods = new ByteVector(n3);
            this.bootstrapMethods.putByteArray(byArray, n, n3);
            int n4 = n;
            for (int i = 0; i < this.bootstrapMethodCount; ++i) {
                int n5 = n4 - n;
                int n6 = classReader.readUnsignedShort(n4);
                int n7 = classReader.readUnsignedShort(n4 += 2);
                n4 += 2;
                int n8 = classReader.readConst(n6, cArray).hashCode();
                while (n7-- > 0) {
                    int n9 = classReader.readUnsignedShort(n4);
                    n4 += 2;
                    n8 ^= classReader.readConst(n9, cArray).hashCode();
                }
                this.add(new SymbolTable$Entry(i, 64, n5, n8 & Integer.MAX_VALUE));
            }
        }
    }

    ClassReader getSource() {
        return this.sourceClassReader;
    }

    int getMajorVersion() {
        return this.majorVersion;
    }

    String getClassName() {
        return this.className;
    }

    int setMajorVersionAndClassName(int n, String string) {
        this.majorVersion = n;
        this.className = string;
        return this.addConstantClass((String)string).index;
    }

    int getConstantPoolCount() {
        return this.constantPoolCount;
    }

    int getConstantPoolLength() {
        return this.constantPool.length;
    }

    void putConstantPool(ByteVector byteVector) {
        byteVector.putShort(this.constantPoolCount).putByteArray(this.constantPool.data, 0, this.constantPool.length);
    }

    int computeBootstrapMethodsSize() {
        if (this.bootstrapMethods != null) {
            this.addConstantUtf8("BootstrapMethods");
            return 8 + this.bootstrapMethods.length;
        }
        return 0;
    }

    void putBootstrapMethods(ByteVector byteVector) {
        if (this.bootstrapMethods != null) {
            byteVector.putShort(this.addConstantUtf8("BootstrapMethods")).putInt(this.bootstrapMethods.length + 2).putShort(this.bootstrapMethodCount).putByteArray(this.bootstrapMethods.data, 0, this.bootstrapMethods.length);
        }
    }

    private SymbolTable$Entry get(int n) {
        return this.entries[n % this.entries.length];
    }

    private SymbolTable$Entry put(SymbolTable$Entry symbolTable$Entry) {
        int n;
        if (this.entryCount > this.entries.length * 3 / 4) {
            n = this.entries.length;
            int n2 = n * 2 + 1;
            SymbolTable$Entry[] symbolTable$EntryArray = new SymbolTable$Entry[n2];
            for (int i = n - 1; i >= 0; --i) {
                SymbolTable$Entry symbolTable$Entry2 = this.entries[i];
                while (symbolTable$Entry2 != null) {
                    int n3 = symbolTable$Entry2.hashCode % n2;
                    SymbolTable$Entry symbolTable$Entry3 = symbolTable$Entry2.next;
                    symbolTable$Entry2.next = symbolTable$EntryArray[n3];
                    symbolTable$EntryArray[n3] = symbolTable$Entry2;
                    symbolTable$Entry2 = symbolTable$Entry3;
                }
            }
            this.entries = symbolTable$EntryArray;
        }
        ++this.entryCount;
        n = symbolTable$Entry.hashCode % this.entries.length;
        symbolTable$Entry.next = this.entries[n];
        this.entries[n] = symbolTable$Entry;
        return this.entries[n];
    }

    private void add(SymbolTable$Entry symbolTable$Entry) {
        ++this.entryCount;
        int n = symbolTable$Entry.hashCode % this.entries.length;
        symbolTable$Entry.next = this.entries[n];
        this.entries[n] = symbolTable$Entry;
    }

    Symbol addConstant(Object object) {
        if (object instanceof Integer) {
            return this.addConstantInteger((Integer)object);
        }
        if (object instanceof Byte) {
            return this.addConstantInteger(((Byte)object).intValue());
        }
        if (object instanceof Character) {
            return this.addConstantInteger(((Character)object).charValue());
        }
        if (object instanceof Short) {
            return this.addConstantInteger(((Short)object).intValue());
        }
        if (object instanceof Boolean) {
            return this.addConstantInteger((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Float) {
            return this.addConstantFloat(((Float)object).floatValue());
        }
        if (object instanceof Long) {
            return this.addConstantLong((Long)object);
        }
        if (object instanceof Double) {
            return this.addConstantDouble((Double)object);
        }
        if (object instanceof String) {
            return this.addConstantString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            int n = type.getSort();
            if (n == 10) {
                return this.addConstantClass(type.getInternalName());
            }
            if (n == 11) {
                return this.addConstantMethodType(type.getDescriptor());
            }
            return this.addConstantClass(type.getDescriptor());
        }
        if (object instanceof Handle) {
            Handle handle = (Handle)object;
            return this.addConstantMethodHandle(handle.getTag(), handle.getOwner(), handle.getName(), handle.getDesc(), handle.isInterface());
        }
        if (object instanceof ConstantDynamic) {
            ConstantDynamic constantDynamic = (ConstantDynamic)object;
            return this.addConstantDynamic(constantDynamic.getName(), constantDynamic.getDescriptor(), constantDynamic.getBootstrapMethod(), constantDynamic.getBootstrapMethodArgumentsUnsafe());
        }
        throw new IllegalArgumentException("value " + object);
    }

    Symbol addConstantClass(String string) {
        return this.addConstantUtf8Reference(7, string);
    }

    Symbol addConstantFieldref(String string, String string2, String string3) {
        return this.addConstantMemberReference(9, string, string2, string3);
    }

    Symbol addConstantMethodref(String string, String string2, String string3, boolean bl) {
        int n = bl ? 11 : 10;
        return this.addConstantMemberReference(n, string, string2, string3);
    }

    private SymbolTable$Entry addConstantMemberReference(int n, String string, String string2, String string3) {
        int n2 = SymbolTable.hash(n, string, string2, string3);
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.owner.equals(string) && symbolTable$Entry.name.equals(string2) && symbolTable$Entry.value.equals(string3)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.put122(n, this.addConstantClass((String)string).index, this.addConstantNameAndType(string2, string3));
        return this.put(new SymbolTable$Entry(this.constantPoolCount++, n, string, string2, string3, 0L, n2));
    }

    private void addConstantMemberReference(int n, int n2, String string, String string2, String string3) {
        this.add(new SymbolTable$Entry(n, n2, string, string2, string3, 0L, SymbolTable.hash(n2, string, string2, string3)));
    }

    Symbol addConstantString(String string) {
        return this.addConstantUtf8Reference(8, string);
    }

    Symbol addConstantInteger(int n) {
        return this.addConstantIntegerOrFloat(3, n);
    }

    Symbol addConstantFloat(float f) {
        return this.addConstantIntegerOrFloat(4, Float.floatToRawIntBits(f));
    }

    private Symbol addConstantIntegerOrFloat(int n, int n2) {
        int n3 = SymbolTable.hash(n, n2);
        SymbolTable$Entry symbolTable$Entry = this.get(n3);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n3 && symbolTable$Entry.data == (long)n2) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.putByte(n).putInt(n2);
        return this.put(new SymbolTable$Entry(this.constantPoolCount++, n, n2, n3));
    }

    private void addConstantIntegerOrFloat(int n, int n2, int n3) {
        this.add(new SymbolTable$Entry(n, n2, n3, SymbolTable.hash(n2, n3)));
    }

    Symbol addConstantLong(long l) {
        return this.addConstantLongOrDouble(5, l);
    }

    Symbol addConstantDouble(double d) {
        return this.addConstantLongOrDouble(6, Double.doubleToRawLongBits(d));
    }

    private Symbol addConstantLongOrDouble(int n, long l) {
        int n2 = SymbolTable.hash(n, l);
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.data == l) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        int n3 = this.constantPoolCount;
        this.constantPool.putByte(n).putLong(l);
        this.constantPoolCount += 2;
        return this.put(new SymbolTable$Entry(n3, n, l, n2));
    }

    private void addConstantLongOrDouble(int n, int n2, long l) {
        this.add(new SymbolTable$Entry(n, n2, l, SymbolTable.hash(n2, l)));
    }

    int addConstantNameAndType(String string, String string2) {
        int n = 12;
        int n2 = SymbolTable.hash(12, string, string2);
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 12 && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.name.equals(string) && symbolTable$Entry.value.equals(string2)) {
                return symbolTable$Entry.index;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.put122(12, this.addConstantUtf8(string), this.addConstantUtf8(string2));
        return this.put((SymbolTable$Entry)new SymbolTable$Entry((int)this.constantPoolCount++, (int)12, (String)string, (String)string2, (int)n2)).index;
    }

    private void addConstantNameAndType(int n, String string, String string2) {
        int n2 = 12;
        this.add(new SymbolTable$Entry(n, 12, string, string2, SymbolTable.hash(12, string, string2)));
    }

    int addConstantUtf8(String string) {
        int n = SymbolTable.hash(1, string);
        SymbolTable$Entry symbolTable$Entry = this.get(n);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 1 && symbolTable$Entry.hashCode == n && symbolTable$Entry.value.equals(string)) {
                return symbolTable$Entry.index;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.putByte(1).putUTF8(string);
        return this.put((SymbolTable$Entry)new SymbolTable$Entry((int)this.constantPoolCount++, (int)1, (String)string, (int)n)).index;
    }

    private void addConstantUtf8(int n, String string) {
        this.add(new SymbolTable$Entry(n, 1, string, SymbolTable.hash(1, string)));
    }

    Symbol addConstantMethodHandle(int n, String string, String string2, String string3, boolean bl) {
        int n2 = 15;
        int n3 = SymbolTable.hash(15, string, string2, string3, n);
        SymbolTable$Entry symbolTable$Entry = this.get(n3);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 15 && symbolTable$Entry.hashCode == n3 && symbolTable$Entry.data == (long)n && symbolTable$Entry.owner.equals(string) && symbolTable$Entry.name.equals(string2) && symbolTable$Entry.value.equals(string3)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        if (n <= 4) {
            this.constantPool.put112(15, n, this.addConstantFieldref((String)string, (String)string2, (String)string3).index);
        } else {
            this.constantPool.put112(15, n, this.addConstantMethodref((String)string, (String)string2, (String)string3, (boolean)bl).index);
        }
        return this.put(new SymbolTable$Entry(this.constantPoolCount++, 15, string, string2, string3, n, n3));
    }

    private void addConstantMethodHandle(int n, int n2, String string, String string2, String string3) {
        int n3 = 15;
        int n4 = SymbolTable.hash(15, string, string2, string3, n2);
        this.add(new SymbolTable$Entry(n, 15, string, string2, string3, n2, n4));
    }

    Symbol addConstantMethodType(String string) {
        return this.addConstantUtf8Reference(16, string);
    }

    Symbol addConstantDynamic(String string, String string2, Handle handle, Object ... objectArray) {
        Symbol symbol = this.addBootstrapMethod(handle, objectArray);
        return this.addConstantDynamicOrInvokeDynamicReference(17, string, string2, symbol.index);
    }

    Symbol addConstantInvokeDynamic(String string, String string2, Handle handle, Object ... objectArray) {
        Symbol symbol = this.addBootstrapMethod(handle, objectArray);
        return this.addConstantDynamicOrInvokeDynamicReference(18, string, string2, symbol.index);
    }

    private Symbol addConstantDynamicOrInvokeDynamicReference(int n, String string, String string2, int n2) {
        int n3 = SymbolTable.hash(n, string, string2, n2);
        SymbolTable$Entry symbolTable$Entry = this.get(n3);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n3 && symbolTable$Entry.data == (long)n2 && symbolTable$Entry.name.equals(string) && symbolTable$Entry.value.equals(string2)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.put122(n, n2, this.addConstantNameAndType(string, string2));
        return this.put(new SymbolTable$Entry(this.constantPoolCount++, n, null, string, string2, n2, n3));
    }

    private void addConstantDynamicOrInvokeDynamicReference(int n, int n2, String string, String string2, int n3) {
        int n4 = SymbolTable.hash(n, string, string2, n3);
        this.add(new SymbolTable$Entry(n2, n, null, string, string2, n3, n4));
    }

    Symbol addConstantModule(String string) {
        return this.addConstantUtf8Reference(19, string);
    }

    Symbol addConstantPackage(String string) {
        return this.addConstantUtf8Reference(20, string);
    }

    private Symbol addConstantUtf8Reference(int n, String string) {
        int n2 = SymbolTable.hash(n, string);
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == n && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.value.equals(string)) {
                return symbolTable$Entry;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        this.constantPool.put12(n, this.addConstantUtf8(string));
        return this.put(new SymbolTable$Entry(this.constantPoolCount++, n, string, n2));
    }

    private void addConstantUtf8Reference(int n, int n2, String string) {
        this.add(new SymbolTable$Entry(n, n2, string, SymbolTable.hash(n2, string)));
    }

    Symbol addBootstrapMethod(Handle handle, Object ... objectArray) {
        int n;
        int n2;
        ByteVector byteVector = this.bootstrapMethods;
        if (byteVector == null) {
            byteVector = this.bootstrapMethods = new ByteVector();
        }
        int n3 = objectArray.length;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = this.addConstant((Object)objectArray[n2]).index;
        }
        n2 = byteVector.length;
        byteVector.putShort(this.addConstantMethodHandle((int)handle.getTag(), (String)handle.getOwner(), (String)handle.getName(), (String)handle.getDesc(), (boolean)handle.isInterface()).index);
        byteVector.putShort(n3);
        for (n = 0; n < n3; ++n) {
            byteVector.putShort(nArray[n]);
        }
        n = byteVector.length - n2;
        int n4 = handle.hashCode();
        for (Object object : objectArray) {
            n4 ^= object.hashCode();
        }
        return this.addBootstrapMethod(n2, n, n4 &= Integer.MAX_VALUE);
    }

    private Symbol addBootstrapMethod(int n, int n2, int n3) {
        byte[] byArray = this.bootstrapMethods.data;
        SymbolTable$Entry symbolTable$Entry = this.get(n3);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 64 && symbolTable$Entry.hashCode == n3) {
                int n4 = (int)symbolTable$Entry.data;
                boolean bl = true;
                for (int i = 0; i < n2; ++i) {
                    if (byArray[n + i] == byArray[n4 + i]) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.bootstrapMethods.length = n;
                    return symbolTable$Entry;
                }
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        return this.put(new SymbolTable$Entry(this.bootstrapMethodCount++, 64, n, n3));
    }

    Symbol getType(int n) {
        return this.typeTable[n];
    }

    int addType(String string) {
        int n = SymbolTable.hash(128, string);
        SymbolTable$Entry symbolTable$Entry = this.get(n);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 128 && symbolTable$Entry.hashCode == n && symbolTable$Entry.value.equals(string)) {
                return symbolTable$Entry.index;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        return this.addTypeInternal(new SymbolTable$Entry(this.typeCount, 128, string, n));
    }

    int addUninitializedType(String string, int n) {
        int n2 = SymbolTable.hash(129, string, n);
        SymbolTable$Entry symbolTable$Entry = this.get(n2);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 129 && symbolTable$Entry.hashCode == n2 && symbolTable$Entry.data == (long)n && symbolTable$Entry.value.equals(string)) {
                return symbolTable$Entry.index;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        return this.addTypeInternal(new SymbolTable$Entry(this.typeCount, 129, string, n, n2));
    }

    int addMergedType(int n, int n2) {
        int n3;
        long l = n < n2 ? (long)n | (long)n2 << 32 : (long)n2 | (long)n << 32;
        int n4 = SymbolTable.hash(130, n + n2);
        SymbolTable$Entry symbolTable$Entry = this.get(n4);
        while (symbolTable$Entry != null) {
            if (symbolTable$Entry.tag == 130 && symbolTable$Entry.hashCode == n4 && symbolTable$Entry.data == l) {
                return symbolTable$Entry.info;
            }
            symbolTable$Entry = symbolTable$Entry.next;
        }
        String string = this.typeTable[n].value;
        String string2 = this.typeTable[n2].value;
        this.put((SymbolTable$Entry)new SymbolTable$Entry((int)this.typeCount, (int)130, (long)l, (int)n4)).info = n3 = this.addType(this.classWriter.getCommonSuperClass(string, string2));
        return n3;
    }

    private int addTypeInternal(SymbolTable$Entry symbolTable$Entry) {
        if (this.typeTable == null) {
            this.typeTable = new SymbolTable$Entry[16];
        }
        if (this.typeCount == this.typeTable.length) {
            SymbolTable$Entry[] symbolTable$EntryArray = new SymbolTable$Entry[2 * this.typeTable.length];
            System.arraycopy(this.typeTable, 0, symbolTable$EntryArray, 0, this.typeTable.length);
            this.typeTable = symbolTable$EntryArray;
        }
        this.typeTable[this.typeCount++] = symbolTable$Entry;
        return this.put((SymbolTable$Entry)symbolTable$Entry).index;
    }

    private static int hash(int n, int n2) {
        return Integer.MAX_VALUE & n + n2;
    }

    private static int hash(int n, long l) {
        return Integer.MAX_VALUE & n + (int)l + (int)(l >>> 32);
    }

    private static int hash(int n, String string) {
        return Integer.MAX_VALUE & n + string.hashCode();
    }

    private static int hash(int n, String string, int n2) {
        return Integer.MAX_VALUE & n + string.hashCode() + n2;
    }

    private static int hash(int n, String string, String string2) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode();
    }

    private static int hash(int n, String string, String string2, int n2) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode() * (n2 + 1);
    }

    private static int hash(int n, String string, String string2, String string3) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    private static int hash(int n, String string, String string2, String string3, int n2) {
        return Integer.MAX_VALUE & n + string.hashCode() * string2.hashCode() * string3.hashCode() * n2;
    }
}

